<?php
	global $VISUAL_COMPOSER_EXTENSIONS;	
    $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element = array(
		"name"                          => __( "TS Video Youtube", "ts_visual_composer_extend" ),
		"base"                          => "TS-VCSC-Youtube",
		"icon" 	                        => "ts-composer-element-icon-youtube",
		"category"                      => __( "Composium", "ts_visual_composer_extend" ),
		"description"                   => __("Place a YouTube Video", "ts_visual_composer_extend"),
		"admin_enqueue_js"              => "",
		"admin_enqueue_css"             => "",
		"params"                        => array(
			// YouTube Video				
			array(
				"type"                  => "seperator",
				"param_name"            => "seperator_1",
				"seperator"				=> "Youtube Video",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "YouTube Content", "ts_visual_composer_extend" ),
				"param_name"            => "content_type",
				"value"                 => array(
					__("Single Video", "ts_visual_composer_extend")          			=> "video",
					__("Defined Playlist", "ts_visual_composer_extend")         		=> "playlist",
					__("Playlist via Search Term(s)", "ts_visual_composer_extend")		=> "searchterm",
					__("Playlist from Individual Videos", "ts_visual_composer_extend")	=> "combination",
					__("Playlist from User Uploads", "ts_visual_composer_extend")		=> "uploads",
				),
				"admin_label"           => true,
				"description"           => __( "Select the type of trigger to click on in order to show the lightbox.", "ts_visual_composer_extend" ),					
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "YouTube Video URL", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube",
				"value"                 => "",
				"admin_label"           => true,
				"description"           => __( "Enter the URL for the YouTube video.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_type", 'value' => 'video' ),
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "YouTube Playlist ID", "ts_visual_composer_extend" ),
				"param_name"            => "content_playlist",
				"value"                 => "",
				"admin_label"           => true,
				"description"           => __( "Enter the URL or ID for a PUBLIC YouTube playlist; playlist ID must start with 'PL'.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_type", 'value' => 'playlist' ),
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "YouTube Search Term(s)", "ts_visual_composer_extend" ),
				"param_name"            => "content_search",
				"value"                 => "",
				"admin_label"           => true,
				"description"           => __( "Enter the search term(s) for videos on YouTube; playlist will show a maximum of 20 videos.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_type", 'value' => 'searchterm' ),
			),
			array(
				"type"                  => "tag_editor",
				"heading"               => __( "YouTube Video ID's", "ts_visual_composer_extend" ),
				"param_name"            => "content_combination",
				"value"                 => "",
				"delimiter"				=> ", ",
				"lowercase"				=> "false",
				"admin_label"           => true,
				"description"           => __( "Enter the ID's of up to 20 videos, separated by comma to build a custom playlist.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_type", 'value' => 'combination' ),
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "YouTube User ID", "ts_visual_composer_extend" ),
				"param_name"            => "content_uploads",
				"value"                 => "",
				"admin_label"           => true,
				"description"           => __( "Enter the User ID of the user whose videos should be shown in a playlist.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_type", 'value' => 'uploads' ),
			),
			// Display Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_2",
				"seperator"				=> "Display Settings",
			),
			array(
				"type"              	=> "switch_button",
				"heading"           	=> __( "Open in Lightbox", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_lightbox",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle to show the video in a lightbox.", "ts_visual_composer_extend" ),
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Video Ratio", "ts_visual_composer_extend" ),
				"param_name"            => "content_ratio",
				"value"                 => array(
					__("1.33:1 (4:3)", "ts_visual_composer_extend")          			=> "ts-ratio-four-to-three",
					__("1.67:1 (3:2)", "ts_visual_composer_extend")         			=> "ts-ratio-three-to-two",
					__("1.60:1 (8:5)", "ts_visual_composer_extend")         			=> "ts-ratio-eight-to-five",
					__("1.78:1 (16:9)", "ts_visual_composer_extend")					=> "ts-ratio-sixteen-to-nine",
					__("1.85:1", "ts_visual_composer_extend")							=> "ts-ratio-oneeightfive-to-one",
					__("2.33:1 (21:9)", "ts_visual_composer_extend")					=> "ts-ratio-twentyone-to-nine",
					__("2.39:1", "ts_visual_composer_extend")							=> "ts-ratio-twothreenine-to-one",
					__("2.67:1", "ts_visual_composer_extend")							=> "ts-ratio-twosixseven-to-one",
					__("2.75:1", "ts_visual_composer_extend")							=> "ts-ratio-twosevenfive-to-one",
					__("3.75:1", "ts_visual_composer_extend")							=> "ts-ratio-threesevenfive-to-one",
				),
				"description"           => __( "Select the width-to-height ratio that the video to be shown within the iFrame is encoded with.", "ts_visual_composer_extend" ),
				"default"				=> 'ts-ratio-sixteen-to-nine',
				"standard"				=> 'ts-ratio-sixteen-to-nine',
				"std"					=> 'ts-ratio-sixteen-to-nine',
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' ),
			),
			array(
				"type"              	=> "switch_button",
				"heading"           	=> __( "Use Overlay Image", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_overlay_use",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle to add an image overlay on top of the video iFrame.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' ),
			),
			// Player Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_3",
				"seperator"				=> "Player Settings",
			),				
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Start Time", "ts_visual_composer_extend" ),
				"param_name"            => "video_start",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "7200",
				"step"                  => "1",
				"unit"                  => 's',
				"description"           => __( "Select a time in seconds at which the video should begin playing; must be smaller than 'End Time'; set to 0 (zero) to disable.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_type", 'value' => 'video' ),
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "End Time", "ts_visual_composer_extend" ),
				"param_name"            => "video_end",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "7200",
				"step"                  => "1",
				"unit"                  => 's',
				"description"           => __( "Select a time in seconds at which the video should stop playing; must be larger than 'Start Time'; set to 0 (zero) to disable..", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_type", 'value' => 'video' ),
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Video Quality", "ts_visual_composer_extend" ),
				"param_name"            => "video_quality",
				"value"                 => array(
					__("Automatic", "ts_visual_composer_extend")				=> "auto",
					__("Tiny (144p)", "ts_visual_composer_extend")				=> "tiny",
					__("Small (240p)", "ts_visual_composer_extend")				=> "small",
					__("Medium (360p)", "ts_visual_composer_extend")			=> "medium",
					__("Large (480p)", "ts_visual_composer_extend")				=> "large",
					__("HD (720p)", "ts_visual_composer_extend")				=> "hd720",
					__("Full HD (1080p)", "ts_visual_composer_extend")			=> "hd1080",
				),
				"description"           => __( "Select the desired initial video quality request for the player; YouTube can still select a different quality if applicable.", "ts_visual_composer_extend" ),					
			),		
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Video Controls 1", "ts_visual_composer_extend" ),
				"param_name"            => "video_controls",
				"value"                 => array(
					__("Player controls display in the player; will show controls immediately.", "ts_visual_composer_extend")				=> "1",
					__("Player controls do NOT display in the player.", "ts_visual_composer_extend")										=> "0",
					__("Player controls display in the player; will show controls after video start.", "ts_visual_composer_extend")			=> "2",
				),
				"description"           => __( "Select if and how the player should provide control elements.", "ts_visual_composer_extend" ),					
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Video Controls 2", "ts_visual_composer_extend" ),
				"param_name"            => "video_autohide",
				"value"                 => array(                        
					__("Automatically hide controls while playing the video.", "ts_visual_composer_extend")									=> "1",
					__("Always show controls while playing the video.", "ts_visual_composer_extend")										=> "0",
					__("Auto Show/Hide (requires 16:9 or 4:3 video aspect ratio; otherwise always visible).", "ts_visual_composer_extend")	=> "2",
				),
				"description"           => __( "Select how the player should adjust the controls after the video started.", "ts_visual_composer_extend" ),					
			),
			array(
				"type"              	=> "switch_button",
				"heading"			    => __( "Loop Video", "ts_visual_composer_extend" ),
				"param_name"		    => "video_loop",
				"value"             	=> "false",
				"description"		    => __( "Switch the toggle if you want to loop and automatically replay the video once it has finished.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "switch_button",
				"heading"			    => __( "Show Related Videos", "ts_visual_composer_extend" ),
				"param_name"		    => "video_related",
				"value"             	=> "false",
				"description"		    => __( "Switch the toggle if you want to show related videos at the end of the video.", "ts_visual_composer_extend" ),                    
			),
			array(
				"type"              	=> "switch_button",
				"heading"			    => __( "Show Video Infobar", "ts_visual_composer_extend" ),
				"param_name"		    => "video_infobar",
				"value"             	=> "true",
				"description"		    => __( "Switch the toggle if you want to show a bar with the video title and other information at the top of the video player.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "switch_button",
				"heading"			    => __( "Use Modest Branding", "ts_visual_composer_extend" ),
				"param_name"		    => "video_modest",
				"value"             	=> "false",
				"description"		    => __( "Switch the toggle if you want to apply only modest YouTube branding to the video player.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "switch_button",
				"heading"			    => __( "Mute Video", "ts_visual_composer_extend" ),
				"param_name"		    => "video_mute",
				"value"             	=> "false",
				"description"		    => __( "Switch the toggle if you want to initially mute the video.", "ts_visual_composer_extend" )
			),
			array(
				"type"              	=> "switch_button",
				"heading"			    => __( "Autoplay Video", "ts_visual_composer_extend" ),
				"param_name"		    => "lightbox_play",
				"value"             	=> "false",
				"description"		    => __( "Switch the toggle if you want to auto-play the video once opened in the lightbox, on pageload (iFrame) or once the overlay has been removed.", "ts_visual_composer_extend" )
			),
			// Overlay Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_4",
				"seperator"				=> "Overlay Settings",
				"dependency"            => array( 'element' => "content_overlay_use", 'value' => 'true' ),
				"group" 				=> "Overlay Settings",
			),				
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Overlay Source", "ts_visual_composer_extend" ),
				"param_name"            => "content_overlay_source",
				"value"                 => array(
					__("WordPress Image", "ts_visual_composer_extend")           			=> "internal",
					__("YouTube Cover (Single Video)", "ts_visual_composer_extend")			=> "preview",
				),
				"description"           => __( "Select the source of the overlay image.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_overlay_use", 'value' => 'true' ),
				"group" 				=> "Overlay Settings",
			),
			array(
				"type"                  => "attach_image",
				"heading"               => __( "Select Cover Image", "ts_visual_composer_extend" ),
				"param_name"            => "content_overlay_image",
				"value"                 => "",
				"description"           => __( "Select the overlay or cover image to placed on top of the video iFrame.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_overlay_source", 'value' => 'internal' ),
				"group" 				=> "Overlay Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Cover Image Quality", "ts_visual_composer_extend" ),
				"param_name"            => "content_overlay_quality",
				"width"                 => 150,
				"value"                 => array(
					__( 'Medium Size Image', "ts_visual_composer_extend" )					=> "medium",
					__( 'Thumbnail Size Image', "ts_visual_composer_extend" )				=> "thumbnail",
					__( 'Large Size Image', "ts_visual_composer_extend" )					=> "large",
					__( 'Full Size Image', "ts_visual_composer_extend" )					=> "full",
				),
				"description"           => __( "Select which image size based on WordPress settings should be used for the preview image.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_overlay_source", 'value' => 'internal' ),
				"group" 				=> "Overlay Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Cover Image Quality", "ts_visual_composer_extend" ),
				"param_name"            => "content_overlay_level",
				"value"                 => array(
					__("Maximum Quality", "ts_visual_composer_extend")           			=> "max",
					__("High Quality", "ts_visual_composer_extend")           				=> "high",
					__("Medium Quality", "ts_visual_composer_extend")           			=> "medium",
					__("Standard Quality", "ts_visual_composer_extend")						=> "standard",
					__("Default Quality", "ts_visual_composer_extend")						=> "default",
				),
				"description"           => __( "Select the quality level for the cover image; depending upon video, not all quality levels might be available.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_overlay_source", 'value' => 'preview'),
				"default"				=> "high",
				"standard"				=> "high",
				"std"					=> "high",
				"group" 				=> "Overlay Settings",
			),	
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Overlay Trigger", "ts_visual_composer_extend" ),
				"param_name"            => "content_overlay_trigger",
				"width"                 => 150,
				"value"                 => array(
					__( 'Click', "ts_visual_composer_extend" )								=> "click",
					__( 'Hover', "ts_visual_composer_extend" )								=> "hover",
				),
				"description"           => __( "Select how the switch from cover image to video should be triggered.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_overlay_use", 'value' => 'true' ),
				"group" 				=> "Overlay Settings",
			),
			array(
				"type"              	=> "switch_button",
				"heading"			    => __( "Overlay Lazyload", "ts_visual_composer_extend" ),
				"param_name"		    => "content_overlay_lazy",
				"value"             	=> "true",
				"description"		    => __( "Switch the toggle if you want to use a lazyload for this video where the iFrame content is only loaded once the overlay has been removed.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_overlay_use", 'value' => 'true' ),
				"group" 				=> "Overlay Settings",
			),
			array(
				"type"              	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorBase64TinyMCE == "true" ? "wysiwyg_base64" : "textarea_raw_html"),
				"heading"           	=> __( "Overlay Text", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_overlay_text",
				"minimal"				=> "true",
				"value"             	=> base64_encode(""),
				"description"      	 	=> __( "Enter a short optional text to be used with the overlay image (HTML code can be used).", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_overlay_use", 'value' => 'true' ),
				"group" 				=> "Overlay Settings",
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Text Align", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_overlay_align",
				"width"             	=> 150,
				"value"             	=> array(
					__( "Center", "ts_visual_composer_extend" )                        		=> "center",
					__( "Left", "ts_visual_composer_extend" )                          		=> "left",
					__( "Right", "ts_visual_composer_extend" )                         		=> "right",
					__( "Justify", "ts_visual_composer_extend" )                        	=> "justify",
				),
				"description"       	=> __( "Select the alignment for the overlay text.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_overlay_use", 'value' => 'true' ),
				"group" 				=> "Overlay Settings",
			),
			array(
				"type"                  => "colorpicker",
				"heading"               => __( "Text Color", "ts_visual_composer_extend" ),
				"param_name"            => "content_overlay_font",
				"value"                 => "#ffffff",
				"description"           => __( "Define the color of the text for the overlay.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_overlay_use", 'value' => 'true' ),
				"group" 				=> "Overlay Settings",
			),
			array(
				"type"              	=> "switch_button",
				"heading"           	=> __( "Show Overlay Indicator", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_overlay_handle",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle to show an overlay indicator handle.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_overlay_use", 'value' => 'true' ),
				"group" 				=> "Overlay Settings",
			),
			array(
				"type"                  => "colorpicker",
				"heading"               => __( "Indicator Color", "ts_visual_composer_extend" ),
				"param_name"            => "content_overlay_color",
				"value"                 => "#fb4400",
				"description"           => __( "Define the color of the overlay indicator.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_overlay_handle", 'value' => 'true' ),
				"group" 				=> "Overlay Settings",
			),
			// Triggger Type
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_5",
				"seperator"				=> "Trigger Settings",
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Trigger Type", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_trigger",
				"value"                 => array(
					__("Default Image", "ts_visual_composer_extend")          				=> "default",
					__("Custom Image", "ts_visual_composer_extend")           				=> "image",
					__("YouTube Cover (Single Video)", "ts_visual_composer_extend")			=> "preview",
					__("YouTube Cover (Defined Playlist)", "ts_visual_composer_extend")		=> "playcover",
					__("YouTube Cover (Individual Videos)", "ts_visual_composer_extend")	=> "coverfirst",
					__("YouTube User Image (User Uploads)", "ts_visual_composer_extend")	=> "usercover",					
					__("Font Icon", "ts_visual_composer_extend")              				=> "icon",
					__("Winged Button", "ts_visual_composer_extend")          				=> "winged",
					__("Simple Button", "ts_visual_composer_extend")          				=> "simple",
					__("Flat Icon Button", "ts_visual_composer_extend")       				=> "flaticon",
					__("Flat Button", "ts_visual_composer_extend")       					=> "flat",
					__("Text", "ts_visual_composer_extend")                   				=> "text",
					__("Custom HTML", "ts_visual_composer_extend")            				=> "custom",
				),
				"admin_label"           => true,
				"description"           => __( "Select the type of trigger to click on in order to show the lightbox.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Trigger Quality", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_quality",
				"value"                 => array(
					__("Maximum Quality", "ts_visual_composer_extend")           			=> "max",
					__("High Quality", "ts_visual_composer_extend")           				=> "high",
					__("Medium Quality", "ts_visual_composer_extend")           			=> "medium",
					__("Standard Quality", "ts_visual_composer_extend")						=> "standard",
					__("Default Quality", "ts_visual_composer_extend")						=> "default",
				),
				"description"           => __( "Select the quality level for the lightbox trigger image; depending upon video, not all quality levels might be available.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => array('preview', 'coverfirst') ),
				"default"				=> "high",
				"standard"				=> "high",
				"std"					=> "high",
				"group" 				=> "Trigger Settings",
			),
			// YouTube API Key Message
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger",
				"color"					=> "#D60000",
				"size"					=> "14",
				"message"            	=> __( "Please ensure that you saved your YouTube API key in the plugin settings or enter a new API key in the input below, as it is required to retrieve the information from YouTube.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => array('playcover','usercover') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "YouTube API Key", "ts_visual_composer_extend" ),
				"param_name"            => "youtube_apikey",
				"value"                 => (isset($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_InformationExternalAPIs['YouTube']) ? $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_InformationExternalAPIs['YouTube'] : ''),
				"description"           => __( "Enter the YouTube API key you want to use for the date request; as default, the global API key as entered in the plugin settings will be used here.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => array('playcover','usercover') ),
				"group" 				=> "Trigger Settings",
			),			
			// Custom Image
			array(
				"type"                  => "attach_image",
				"heading"               => __( "Select Image", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_image",
				"value"                 => "",
				"description"           => __( "Select the preview image for the lightbox content.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => 'image' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"              	=> "switch_button",
				"heading"			    => __( "Simple Image Only", "ts_visual_composer_extend" ),
				"param_name"		    => "content_youtube_image_simple",
				"value"             	=> "false",
				"description"		    => __( "Switch the toggle if you want display just the image without any styling.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => 'image' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Auto Height Setting", "ts_visual_composer_extend" ),
				"param_name"            => "content_image_height",
				"width"                 => 150,
				"value"                 => array(
					__( '100% Height Setting', "ts_visual_composer_extend" )		=> "height: 100%;",
					__( 'Auto Height Setting', "ts_visual_composer_extend" )     	=> "height: auto;",
				),
				"description"           => __( "Select what CSS height setting should be applied to the image (change only if image height does not display correctly).", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => array('preview', 'default', 'image', 'playcover', 'usercover') ),
				"group" 				=> "Trigger Settings",
			),
			// Font Icon
			array(
				"type" 					=> "icons_panel",
				'heading' 				=> __( 'Select Icon', 'ts_visual_composer_extend' ),
				'param_name' 			=> 'content_youtube_icon',
				'value'					=> '',
				"settings" 				=> array(
					"emptyIcon" 				=> false,
					'emptyIconValue'			=> 'transparent',
					"type" 						=> 'extensions',
				),
				"description"       	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon you want to display.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => array('icon', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),			
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Icon Size", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_iconsize",
				"value"                 => "30",
				"min"                   => "16",
				"max"                   => "512",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the icon / image size", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => 'icon' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "colorpicker",
				"heading"               => __( "Icon Color", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_iconcolor",
				"value"                 => "#cccccc",
				"description"           => __( "Define the color of the icon.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => 'icon' ),
				"group" 				=> "Trigger Settings",
			),
			// Flat Button
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Button Color Style", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_buttonstyle",
				"width"                 => 300,
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Default_Colors,
				"description"           => __( "Select the general color style for button.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => array('flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Button Hover Style", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_buttonhover",
				"width"                 => 300,
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Hover_Colors,
				"description"           => __( "Select the general hover style for button.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => array('flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			// Button
			array(
				"type"                  => "textfield",
				"heading"               => __( "Button Text", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_buttontext",
				"value"                 => "View Video",
				"description"           => __( "Enter the text for the button.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => array('winged', 'simple', 'flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Button Text Size", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_buttonsize",
				"value"                 => "16",
				"min"                   => "12",
				"max"                   => "20",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the font size for the trigger button.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => array('flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			// Text Link
			array(
				"type"                  => "textfield",
				"heading"               => __( "Trigger Text", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_text",
				"value"                 => "",
				"description"           => __( "Enter the trigger text for the video.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => 'text' ),
				"group" 				=> "Trigger Settings",
			),
			// Custom Code
			array(
				"type"                  => "textarea_raw_html",
				"heading"               => __("Raw HTML", "ts_visual_composer_extend"),
				"param_name"            => "content_raw",
				"value"                 => base64_encode(""),
				"description"           => __("Enter your custom HTML code; code will be wrapped in appropriate link automatically.", "ts_visual_composer_extend"),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => 'custom' ),
				"group" 				=> "Trigger Settings",
			),
			// Title + Subtitle
			array(
				"type"                  => "textfield",
				"heading"               => __( "Title", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_title",
				"value"                 => "",
				"description"           => __( "Enter a title for the lightbox content.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => array('image', 'default', 'preview', 'playcover', 'usercover', 'winged', 'flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Subtitle", "ts_visual_composer_extend" ),
				"param_name"            => "content_youtube_subtitle",
				"value"                 => "",
				"description"           => __( "Enter a subtitle for the lightbox content.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_youtube_trigger", 'value' => array('winged') ),
				"group" 				=> "Trigger Settings",
			),
			// Overlay Settings
			array(
				"type"                  => "seperator",
				"param_name"            => "seperator_6",
				"seperator"             => "Overlay Settings",
				"dependency"        	=> array( 'element' => "content_youtube_trigger", 'value' => array('default', 'image', 'preview', 'playcover', 'coverfirst', 'usercover') ),				
				"group" 				=> "Trigger Settings",
			),			
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Overlay: Background Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_background",
				"value"             	=> "rgba(24, 24, 24, 0.3)",
				"description"       	=> __( "Select the background color and opacity for the overlay.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "content_youtube_trigger", 'value' => array('default', 'image', 'preview', 'playcover', 'coverfirst', 'usercover') ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",	
				"group" 				=> "Trigger Settings"
			),		
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Overlay: Animation", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_animation",
				"width"             	=> 300,
				"value"             	=> array(
					__( "Zoom Effect", "ts_visual_composer_extend" )				=> "zoom",
					__( "Zoom + Rotate Effect", "ts_visual_composer_extend" )		=> "rotate",
					__( "No Effect", "ts_visual_composer_extend" )					=> "none",
				),
				"description"       	=> __( "Select if and what type of animation should be applied to the image on hover.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "content_youtube_trigger", 'value' => array('default', 'image', 'preview', 'playcover', 'coverfirst', 'usercover') ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group" 				=> "Trigger Settings"
			),			
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Overlay: Decoration", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_decoration",
				"width"             	=> 300,
				"value"             	=> array(
					__( "Default Image", "ts_visual_composer_extend" )				=> "default",
					__( "Custom Internal Image", "ts_visual_composer_extend" )		=> "image",
					__( "Custom External Image", "ts_visual_composer_extend" )		=> "external",
					__( "Font Icon", "ts_visual_composer_extend" )					=> "icon",
					__( "No Decoration", "ts_visual_composer_extend" )				=> "none",
				),
				"description"       	=> __( "Select if and how the overlay should be decorated.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "content_youtube_trigger", 'value' => array('default', 'image', 'preview', 'playcover', 'coverfirst', 'usercover') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Overlay: Visibility", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_visibility",
				"width"             	=> 300,
				"value"             	=> array(
					__( "Show Only On Hover", "ts_visual_composer_extend" )			=> "hover",
					__( "Always Show Decoration", "ts_visual_composer_extend" )		=> "only_deco",
					__( "Always Show Title", "ts_visual_composer_extend" )			=> "only_title",
					__( "Always Show Full Overlay", "ts_visual_composer_extend" )	=> "always",
				),
				"admin_label"           => true,
				"description"       	=> __( "Select if and when the overlay should be visible.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "content_youtube_trigger", 'value' => array('default', 'image', 'preview', 'playcover', 'coverfirst', 'usercover') ),
				"group" 				=> "Trigger Settings",
			),			
			array(
				"type"              	=> "attach_image",
				"heading"           	=> __( "Overlay: Decoration Image", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_image",
				"value"             	=> "",
				"description"       	=> __( "Select an image to be used as decoration for the overlay.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => 'image' ),
				"group" 				=> "Trigger Settings",
			),	
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Overlay: Decoration Image", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_external",
				"value"             	=> "",
				"description"       	=> __( "Enter the full path to the image to be used as decoration for the overlay.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => 'external' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type" 					=> "icons_panel",
				'heading' 				=> __( 'Overlay: Decoration Icon', 'ts_visual_composer_extend' ),
				'param_name' 			=> 'overlay_icon_name',
				'value'					=> '',
				"settings" 				=> array(
					"emptyIcon" 				=> false,
					'emptyIconValue'			=> 'transparent',
					"type" 						=> 'extensions',
				),
				"description"       	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon to be used as decoration for the overlay.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => 'icon' ),
				"group" 				=> "Trigger Settings",
			),			
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Overlay: Decoration Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_icon_color",
				"value"             	=> "#ededed",
				"description"       	=> __( "Select the color for the decoration element.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => 'icon' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Overlay: Decoration Size", "ts_visual_composer_extend" ),
				"param_name"            => "overlay_size",
				"value"                 => "100",
				"min"                   => "50",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Define the size of the decoration element in the overlay.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => array('icon', 'image', 'external') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Overlay: Decoration Opacity", "ts_visual_composer_extend" ),
				"param_name"            => "overlay_opacity",
				"value"                 => "75",
				"min"                   => "50",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => '%',
				"description"           => __( "Define the opacity of the decoration element in the overlay.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => array('icon', 'image', 'external') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Overlay: Title Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_title_color",
				"value"             	=> "#ffffff",
				"description"       	=> __( "Select the font color for the overlay title.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "content_youtube_trigger", 'value' => array('default', 'image', 'preview', 'playcover', 'coverfirst', 'usercover') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Overlay: Title Background", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_title_back",
				"value"             	=> "rgba(0, 0, 0, 0.4)",
				"description"       	=> __( "Select the background color and opacity for the overlay title.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "content_youtube_trigger", 'value' => array('default', 'image', 'preview', 'playcover', 'coverfirst', 'usercover') ),
				"group" 				=> "Trigger Settings",
			),
			// Lightbox Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_7",
				"seperator"				=> "Lightbox Settings",
				"dependency"            => array( 'element' => "content_lightbox", 'value' => "true" ),
				"group" 				=> "Lightbox Settings",
			),				
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Maximum Lightbox Width", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_width",
				"width"                 => 150,
				"value"                 => array(
					__( 'Auto', "ts_visual_composer_extend" )                 	=> "auto",
					__( 'Set Width (%)', "ts_visual_composer_extend" )        	=> "widthpercent",
					__( 'Set Width (px)', "ts_visual_composer_extend" )       	=> "widthpixel",
				),
				"description"           => __( "Select how the maximum element width inside the lightbox should be determined.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Width", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_width_percent",
				"value"                 => "100",
				"min"                   => "25",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => '%',
				"description"           => __( "Select the maximum element width inside the lightbox in percent.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_width", 'value' => 'widthpercent' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Width", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_width_pixel",
				"value"                 => "960",
				"min"                   => "1",
				"max"                   => "1920",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the maximum element width inside the lightbox in px.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_width", 'value' => 'widthpixel' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Maximum Lightbox Height", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_height",
				"width"                 => 150,
				"value"                 => array(
					__( 'Auto', "ts_visual_composer_extend" )                 	=> "auto",
					__( 'Set Height (%)', "ts_visual_composer_extend" )      	=> "heightpercent",
					__( 'Set Height (px)', "ts_visual_composer_extend" )      	=> "heightpixel",
				),
				"description"           => __( "Select how the maximum element height inside the lightbox should be determined.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Height", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_height_percent",
				"value"                 => "100",
				"min"                   => "25",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => '%',
				"description"           => __( "Select the maximum element height inside the lightbox in percent.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_height", 'value' => 'heightpercent' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Height", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_height_pixel",
				"value"                 => "540",
				"min"                   => "100",
				"max"                   => "1080",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the maximum element height inside the lightbox in px.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_height", 'value' => 'heightpixel' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Group Name", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_group_name",
				"value"                 => "krautgroup",
				"description"           => __( "Enter a custom group name to manually build group with other non-gallery items; leave empty for non-grouping", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => "true" ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Transition Effect", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_effect",
				"width"                 => 150,
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Lightbox_Animations,
				"default" 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_LightboxDefaultAnimation,
				"std" 					=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_LightboxDefaultAnimation,
				"admin_label"           => true,
				"description"           => __( "Select the transition effect to be used for the image in the lightbox.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => "true" ),
				"group" 				=> "Lightbox Settings",
			),
			// Tooltip Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_8",
				"seperator"				=> "Tooltip Settings",
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"              	=> "switch_button",
				"heading"           	=> __( "Use HTML Tooltip", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_tooltip_html",
				"value"             	=> "false",
				"description"		    => __( "Switch the toggle if you want to apply a tooltip with HTML code to the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"				    => "textarea",
				"heading"			    => __( "Tooltip Content", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_content",
				"value"				    => "",
				"description"		    => __( "Enter the tooltip content here (do NOT use quotation marks or HTML code).", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_tooltip_html", 'value' => "false" ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"              	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorBase64TinyMCE == "true" ? "wysiwyg_base64" : "textarea_raw_html"),
				"heading"           	=> __( "Tooltip Content", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_tooltip_encoded",
				"minimal"				=> "true",
				"value"             	=> base64_encode(""),
				"description"      	 	=> __( "Enter the tooltip content here (HTML code can be used).", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_tooltip_html", 'value' => "true" ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Tooltip Position", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_position",
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Vertical,
				"description"		    => __( "Select the tooltip position in relation to the image.", "ts_visual_composer_extend" ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Tooltip Style", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_style",
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Layouts,
				"description"		    => __( "Select the tooltip style.", "ts_visual_composer_extend" ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Tooltip Animation", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_animation",
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Animations,
				"description"		    => __( "Select how the tooltip entry and exit should be animated once triggered.", "ts_visual_composer_extend" ),
				"group"					=> "Tooltip Settings",
			),
			array(
				"type"					=> "nouislider",
				"heading"				=> __( "Tooltip X-Offset", "ts_visual_composer_extend" ),
				"param_name"			=> "tooltipster_offsetx",
				"value"					=> "0",
				"min"					=> "-100",
				"max"					=> "100",
				"step"					=> "1",
				"unit"					=> 'px',
				"description"			=> __( "Define an optional X-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"					=> "nouislider",
				"heading"				=> __( "Tooltip Y-Offset", "ts_visual_composer_extend" ),
				"param_name"			=> "tooltipster_offsety",
				"value"					=> "0",
				"min"					=> "-100",
				"max"					=> "100",
				"step"					=> "1",
				"unit"					=> 'px',
				"description"			=> __( "Define an optional Y-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"group" 				=> "Tooltip Settings",
			),
			// Other Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_9",
				"seperator"				=> "Other Settings",
				"group"					=> "Other Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Margin: Top", "ts_visual_composer_extend" ),
				"param_name"            => "margin_top",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
				"group"					=> "Other Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Margin: Bottom", "ts_visual_composer_extend" ),
				"param_name"            => "margin_bottom",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
				"group"					=> "Other Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Define ID Name", "ts_visual_composer_extend" ),
				"param_name"            => "el_id",
				"value"                 => "",
				"description"           => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
				"group"					=> "Other Settings",
			),
			array(
				"type"                  => "tag_editor",
				"heading"           	=> __( "Extra Class Names", "ts_visual_composer_extend" ),
				"param_name"            => "el_class",
				"value"                 => "",
				"description"      		=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
		)
	);	
	if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
		return $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element;
	} else {			
		vc_map($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element);
	};
?>